/**
* \file: daemon_model.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: authorization level daemon
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef ALD_MODEL_DAEMON_MODEL_H
#define ALD_MODEL_DAEMON_MODEL_H

#include <stdbool.h>

#include "ald_types.h"

/**
 * \brief part of the model that is written to storage on changes
 */
typedef struct persistent_model_t
{
	security_level_t current_persisted_level;
	security_level_t targeted_persisted_level;
} __attribute__((aligned(4))) persistent_model_t;

/**
 * \brief the overall model
 *
 * Contains the volatile elements as well as the persistent ones
 */
typedef struct daemon_model_t
{
	daemon_level_state_t daemon_level_state;
	daemon_service_state_t daemon_service_state;
	security_level_t current_active_level;
	security_level_t targeted_active_level;
	persistent_model_t persistent_model;
	persistent_model_t state_file_model;
} __attribute__((aligned(4))) daemon_model_t;

//---------------------------------- model init, persist, and deinit -----------------------------------------------------------
error_code_t daemon_model_init(void);

error_code_t daemon_model_persist(void);

void daemon_model_deinit(void);
//--------------------------------------------------------------------------------------------------------------------


//---------------------------------- information about current levels ------------------------------------------------
security_level_t daemon_model_get_active_level(void);

security_level_t daemon_model_get_targeted_active_level(void);

security_level_t daemon_model_get_persisted_level(void);

security_level_t daemon_model_get_targeted_persisted_level(void);

//--------------------------------------------------------------------------------------------------------------------

//---------------------------------- information on incomplete transactions ------------------------------------------------

bool daemon_model_is_recovery_needed(void);

security_level_t daemon_model_get_recovery_level(void);

//--------------------------------------------------------------------------------------------------------------------

//--------------------------------------------------------------------------------------------------------------------

//---------------------------------- getting and changing the daemon states ------------------------------------------
daemon_level_state_t daemon_model_get_level_state(void);

const char *daemon_model_get_level_state_name(daemon_level_state_t state);

daemon_service_state_t daemon_model_get_service_state(void);

const char *daemon_model_get_service_state_name(daemon_service_state_t state);

void daemon_model_set_state_recovery_ongoing(security_level_t recovery_level);

void daemon_model_set_state_change_ongoing(security_level_t new_active_level, security_level_t new_persisted_level);

void daemon_model_set_stable_levels(security_level_t active_level,
				    security_level_t persisted_level,
				    bool completed_with_error);

void daemon_model_schedule_fail_safe_recovery();

void daemon_model_set_state_idle(bool recovery_on_next_startup);

void daemon_model_set_state_shutting_down(void);

void daemon_model_app_iface_set_ready(void);
//--------------------------------------------------------------------------------------------------------------------

#endif
